#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "plplot.h"
#include "drp.h"

#define WINDOW    1
#define VIEWPORT  2
  
static float xarray[MAXCHANNELS];
static float yarray[MAXCHANNELS];

int Units, CtrlWord;
  
int xLabels, yLabels;
  
SCAN work, temp;
char *angle(float, int);
void Header (SCAN *);

extern int zeroline, frame, relative, grid, title;
extern char NewTitle[];

void scatter(int xUnit, float xlo, float xhi)
{
    float xMin, xMax, yMin, yMax;
    float X, xStep, Y, yStep;
    float swap, delta = 0.0;
    int FirstCh, LastCh, NCh;
    int i;
  
    GetScan(&work);
    GetTemp(&temp);
    FirstCh = 0; LastCh = work.NChannel-1;
  
    switch (xUnit) {
      case VELOCITY:
	delta = work.VelRes;
	break;
      case FREQUENCY:
	delta = work.FreqRes;
	break;
      case CHANNELS:
	delta = 1.0;
	break;
    }

    if (delta < 0.0) {
	swap = xlo; 
	xlo = xhi; 
	xhi = swap;
    }
  
    if (xlo != 0.0 || xhi != 0.0) {
	switch (xUnit) {
	  case VELOCITY:
            FirstCh = VChannel((double)xlo, &work);
            LastCh  = VChannel((double)xhi, &work);
            break;
	  case FREQUENCY:
            if (xlo < 1000.0) xlo *= 1000.0;
            if (xhi < 1000.0) xhi *= 1000.0;
            FirstCh = FChannel((double)xlo, &work);
            LastCh  = FChannel((double)xhi, &work);
            break;
	  case CHANNELS:
            FirstCh = (int)xlo; FirstCh--;
            LastCh  = (int)xhi; LastCh--;
	}
    } else {
	FirstCh = 0;
	LastCh = work.NChannel;
    }

    if (FirstCh > LastCh) {
	i = FirstCh;
	FirstCh = LastCh;
	LastCh = i;
    }
  
    NCh = LastCh - FirstCh + 1;
  
    xMin = work.Channels[FirstCh];
    xMax = work.Channels[FirstCh];
    for (i=1; i<NCh; i++) {
	X = work.Channels[FirstCh+i];
	if (X < xMin) xMin = X;
	if (X > xMax) xMax = X;
    }
    xStep = (xMax-xMin)/20.0;
    xMin -= xStep;
    xMax += xStep;

    yMin = temp.Channels[FirstCh];
    yMax = temp.Channels[FirstCh];
    for (i=1; i<NCh; i++) {
	Y = temp.Channels[FirstCh+i];
	if (Y < yMin) yMin = Y;
	if (Y > yMax) yMax = Y;
    }
    yStep = (yMax-yMin)/20.0;
    yMin -= yStep;
    yMax += yStep;

    pladv(0);
    plvsta();
    plwind((PLFLT)xMin, (PLFLT)xMax, (PLFLT)yMin, (PLFLT)yMax);
    if (frame) {
	if (grid) plbox("abcgnst", (PLFLT)0.0, 0, "abcgnstv", (PLFLT)0.0, 0);
	else      plbox("bcnst", (PLFLT)0.0, 0, "bcnstv", (PLFLT)0.0, 0);
	if (title) pllab("work area", "temp area", NewTitle);
	else pllab("work area", "temp area","scatter plot");
    } else {
	plbox("at", (PLFLT)0.0, 0, "at", (PLFLT)0.0, 0);
    }	

    if (zeroline) {
	if (yMin < 0.0 && yMax > 0.0) {
	    xarray[0] = xMin;
	    xarray[1] = xMax;
	    yarray[0] = 0.0;
	    yarray[1] = 0.0;
	}
	plline(2, xarray, yarray);
    }

    for (i=0; i<NCh; i++) {
	xarray[i] = work.Channels[FirstCh+i];
	yarray[i] = temp.Channels[FirstCh+i];
    }
    plpoin(NCh, xarray, yarray, 2);
}
