#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <sys/stat.h>
#include <errno.h>
#include "drp.h"

#define L_KEY 0x47110000
#define CREATE (IPC_CREAT | 0600)

typedef struct {
    SCAN work;
    SCAN temp;
    SCAN hold;
} segment;

/* function codes for request messages */
#define MSG_SHOW     1
#define MSG_QUIT     2

typedef struct {
    long type;             /* message type                */
    int pid;               /* process-id of requester     */
    int uid;               /* user-id of requester        */
    int function;          /* requested function          */
    int tags;              /* number of tags to follow    */
} request;

typedef struct {
    long type;             /* tag type                    */
    union {
	float f;           /* tag float value            */
	int i;             /* tag integer value           */
    } value;
} msgtag;

typedef struct {
    long type;             /* message type                */
    unsigned short status; /* status of request           */
    unsigned short reason; /* reason for failure          */
} reply;

#define REQSIZE (sizeof(request) - sizeof(long))
#define RPLSIZE (sizeof(reply) - sizeof(long))

int semid;
int shmid;

struct sembuf seize = { 0, -1, 0 };
struct sembuf relse = { 0,  1, 0 };

