#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include "plplot.h"
#include "drp.h"
#include "options.h"

#define NO  0
#define YES 1

#define VIEWPORT 2  

/* defaults */
double xMin = 0.0, xMax = 0.0;
double yMin = 0.0, yMax = 0.0;
int xUnit = VELOCITY;
int Units = YES;
int frame = YES;
int draft = YES;
int overwrite = NO;
int zeroline = NO;
int histogram = NO;
int relative = NO;
int grid = NO;
int title = NO;
int label[2] = { NO, NO };
int viewport = NO;
char NewTitle[80];
char xLabel[80], yLabel[80];

char PROGRAM_NAME[] = "show";
char description[] = "produce plot of spectrum";
char required[] = "";
struct _options options[] = {
    { "-help",              "Print out this message" },
    { "-vel v1 v2",         "select velocity range" },
    { "-freq f1 f2",        "select frequency range" },
    { "-chan c1 c2",        "select channel range" },
    { "-temp t1 t2",        "select intensity range" },
    { "-histo",             "show histogram" },
    { "-over",              "write over existing plot" },
    { "-zero",              "draw y = 0.0 line" },
    { "-title text",        "specify new title for plot" },
    { "-xlabel text",       "specify new label for x-axis" },
    { "-ylabel text",       "specify new label for y-axis" },
    { "-noframe",           "don't draw coordinate frame" },
    { "-nodraft",           "use extended font for high quality labels" },
    { "-rel",               "label x-axis relative to centre channel" },
    { "-grid",              "draw grid at major tick intervals" },
    { "-view",              "specify viewport" },
    {NULL, NULL }
};

SCAN OnScan;

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
        Help();
        exit(EX_SUCCESS);
    }
    if (!strcmp(opt, "vel")) {
        GetOption(&optarg, pargc, pargv);
        xMin = atof(optarg);
        GetOption(&optarg, pargc, pargv);
        xMax = atof(optarg);
        xUnit = VELOCITY;
        return;
    }
    if (!strcmp(opt, "freq")) {
        GetOption(&optarg, pargc, pargv);
        xMin = atof(optarg);
        GetOption(&optarg, pargc, pargv);
        xMax = atof(optarg);
        xUnit = FREQUENCY;
        return;
    }
    if (!strcmp(opt, "chan")) {
        GetOption(&optarg, pargc, pargv);
        xMin = (double)atoi(optarg);
        GetOption(&optarg, pargc, pargv);
        xMax = (double)atoi(optarg);
        xUnit = CHANNELS;
        return;
    }
    if (!strcmp(opt, "temp")) {
        GetOption(&optarg, pargc, pargv);
        yMin = atof(optarg);
        GetOption(&optarg, pargc, pargv);
        yMax = atof(optarg);
        return;
    }
    if (!strcmp(opt, "over")) {
        overwrite = YES;
        return;
    }
    if (!strcmp(opt, "zero")) {
        zeroline = YES;
        return;
    }
    if (!strcmp(opt, "title")) {
        title = YES;
        GetOption(&optarg, pargc, pargv);
        strcpy(NewTitle, optarg);
        return;
    }
    if (!strcmp(opt, "xlabel")) {
        label[0] = YES;
        GetOption(&optarg, pargc, pargv);
        strcpy(xLabel, optarg);
        return;
    }
    if (!strcmp(opt, "ylabel")) {
        label[1] = YES;
        GetOption(&optarg, pargc, pargv);
        strcpy(yLabel, optarg);
        return;
    }
    if (!strcmp(opt, "histo")) {
        histogram = YES;
        return;
    }
    if (!strcmp(opt, "noframe")) {
        frame = NO;
        return;
    }
    if (!strcmp(opt, "nodraft")) {
        draft = NO;
        return;
    }
    if (!strcmp(opt, "rel")) {
        relative = YES;
        return;
    }
    if (!strcmp(opt, "grid")) {
        grid = YES;
        return;
    }
    if (!strcmp(opt, "view")) {
        OnScan.flag[2] = VIEWPORT;
        GetOption(&optarg, pargc, pargv);
        OnScan.work[4] = atof(optarg);
        GetOption(&optarg, pargc, pargv);
        OnScan.work[5] = atof(optarg);
        GetOption(&optarg, pargc, pargv);
        OnScan.work[6] = atof(optarg);
        GetOption(&optarg, pargc, pargv);
        OnScan.work[7] = atof(optarg);
        return;
    }
    Syntax(**pargv);
}

void spect(int , float , float , float , float );

int main (int argc, char *argv[])
{
    /* FILE *meta; */
    int id;
    double swap;
    /* static char metaname[MAXNAMLEN+1]; */
     
    GetScan(&OnScan);
    GetOpts(argc, argv);

    if (xMin > xMax) {  swap = xMin;    xMin = xMax;    xMax = swap;    }
    if (yMin > yMax) {  swap = yMin;    yMin = yMax;    yMax = swap;    }

    /* if ((id = fork()) == 0) { */
    /*     strcpy(metaname, getenv("HOME")); */
    /*     strcat(metaname, METAFILE); */
    /*     if (!overwrite) meta = fopen(metaname, "w"); */
    /*     else            meta = fopen(metaname, "a"); */
    /*     if (meta == NULL) DRPerror("can't open metacode file"); */

    /*     plsfile(meta); */
    /*     plstart("plmeta", 1, 1);  */
    /* } else { */
        plstart(PLDEVICE, 1, 1); 
        if (!overwrite) plclr();
    /* } */

    if (!draft) {
        plfontld(1);
        plfont(2);
        plwid(4);
    }

    spect(xUnit, (float)xMin, (float)xMax, (float)yMin, (float)yMax);
    plend();

    id = 1;
    if (id) PutScan(&OnScan);
    /* else fclose(meta); */

    exit (EX_SUCCESS);
}
