#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "plplot.h"
#include "drp.h"

#undef DEBUG

#define COVER 0
#define CONTR 1
#define SCANS 2
#define VALUE 3
#define SHADE 4
#define SPECT 5
    
#define RATYPE   1
#define DECTYPE  2
#define VELTYPE  3
#define FREQTYPE 4

static PLFLT *x, *y, **z;
static PLFLT xbox[5], ybox[5];
static PLFLT *xv, *yv;

extern int which;
extern int title;
extern char NewTitle[];
extern float level, dl;
extern int plane;
extern int geo[];
extern struct Axis {
    int dim;
    int type;
    char label[16];
    double pixel;
    double value;
    double delta;
    double rotate;
} axis[];

PLFLT tr[6];
PLFLT *clevel;

void xform(PLFLT x, PLFLT y, PLFLT * tx, PLFLT * ty)
{
    *tx = tr[0] * x + tr[1] * y + tr[2];
    *ty = tr[3] * x + tr[4] * y + tr[5];
/*  printf("[%f][%f] --> (%f,%f)\n", x, y, *tx, *ty); */
}

void showcube(float *rp)
{
    int i, j, k, nl, index;
    PLINT nx, ny, nz;
    PLFLT xmin, xmax, ymin, ymax, zmin, zmax;
    PLFLT xdelta, ydelta, swap;

    for (i = 0; i < 3; i++) {
	/* printf("%d ", geo[i]); */
	geo[i]--;
    }
    /* printf("\n"); */

    nx = axis[geo[0]].dim;
    ny = axis[geo[1]].dim;
    nz = axis[geo[2]].dim;

#ifdef DEBUG
    for (k = 0; k < axis[2].dim; k++) {
	for (j = 0; j < axis[1].dim; j++) {
	    for (i = 0; i < axis[0].dim; i++) {
		index = (k*axis[1].dim + j)*axis[0].dim + i;
		printf("rp[%4d](%d,%d,%d) = %10.3f\n", index, i,j,k,rp[index]);
	    }
	}
	printf("\n");
    }
#endif

    x = (PLFLT *)calloc(nx, sizeof(PLFLT));
    if (x == NULL) DRPerror("memory allocation failure");

    y = (PLFLT *)calloc(ny, sizeof(PLFLT));
    if (y == NULL) DRPerror("memory allocation failure");

    z = (PLFLT **)calloc(nx, sizeof(PLFLT *));
    if (z == NULL) DRPerror("memory allocation failure");
    for (i = 0; i < nx; i++) {
        z[i] = (PLFLT *)calloc(ny, sizeof(PLFLT));
        if (z[i] == NULL) DRPerror("memory allocation failure");
    }

    xmin = axis[geo[0]].value + axis[geo[0]].delta*(1-axis[geo[0]].pixel);
    xmax = axis[geo[0]].value + axis[geo[0]].delta*(nx-axis[geo[0]].pixel);
    xdelta = axis[geo[0]].delta;
    for (i = 0; i < nx; i++) {
	x[i] = axis[geo[0]].value 
	  + axis[geo[0]].delta*((i+1)-axis[geo[0]].pixel);
    }
    
    switch (axis[geo[0]].type) {
      case RATYPE:
      case DECTYPE:
	xmin -= axis[geo[0]].value;
	xmax -= axis[geo[0]].value;
	xmin *= 60.0;
	xmax *= 60.0;
	xdelta *= 60.0;
	strcpy(axis[geo[0]].label, "offset [arcmin]");
	break;
      case VELTYPE:
	strcpy(axis[geo[0]].label, "velocity [km/s]");
	break;
    }

    ymin = axis[geo[1]].value + axis[geo[1]].delta*(1-axis[geo[1]].pixel);
    ymax = axis[geo[1]].value + axis[geo[1]].delta*(ny-axis[geo[1]].pixel);
    ydelta = axis[geo[1]].delta;
    for (i = 0; i < ny; i++) {
	y[i] = axis[geo[1]].value
	  + axis[geo[1]].delta*((i+1)-axis[geo[1]].pixel);
    }
    switch (axis[geo[1]].type) {
      case RATYPE:
      case DECTYPE:
	ymin -= axis[geo[1]].value;
	ymax -= axis[geo[1]].value;
	ymin *= 60.0;
	ymax *= 60.0;
	ydelta *= 60.0;
	strcpy(axis[geo[1]].label, "offset [arcmin]");
	break;
      case VELTYPE:
	strcpy(axis[geo[1]].label, "velocity [km/s]");
	break;
    }

    if (plane == 0) plane = axis[geo[2]].dim/2;

    switch (geo[0]) {
      case 0:
	switch (geo[1]) {
	  case 1:
	    for (i = 0; i < nx; i++) {
		for (j = 0; j < ny; j++) {
		    index = (plane*axis[1].dim + j)*axis[0].dim+i;
		    if (index < 0 || index > nx*ny*nz) 
		      DRPerror("index out of range (%d) [0,1]", index);
		    z[i][j] = (PLFLT)rp[index];
		}
	    }
	    break;
	  case 2:
	    for (i = 0; i < nx; i++) {
		for (j = 0; j < ny; j++) {
		    index = (j*axis[1].dim + plane)*axis[0].dim+i;
		    if (index < 0 || index > nx*ny*nz) 
		      DRPerror("index out of range (%d) [0,2]", index);
		    z[i][j] = (PLFLT)rp[index];
		}
	    }
	    break;
	}
	break;
      case 1:
	switch (geo[1]) {
	  case 0:
	    for (i = 0; i < nx; i++) {
		for (j = 0; j < ny; j++) {
		    index = (plane*axis[1].dim + i)*axis[0].dim+j;
		    if (index < 0 || index > nx*ny*nz) 
		      DRPerror("index out of range (%d) [1,0]", index);
		    z[i][j] = (PLFLT)rp[index];
		}
	    }
	    break;
	  case 2:
	    for (i = 0; i < nx; i++) {
		for (j = 0; j < ny; j++) {
		    index = (j*axis[1].dim + i)*axis[0].dim+plane;
		    if (index < 0 || index > nx*ny*nz) 
		      DRPerror("index out of range (%d) [1,2]", index);
		    z[i][j] = (PLFLT)rp[index];
		}
	    }
	    break;
	}
	break;
      case 2:
	switch (geo[1]) {
	  case 0:
	    for (i = 0; i < nx; i++) {
		for (j = 0; j < ny; j++) {
		    index = (i*axis[1].dim + j)*axis[0].dim+plane;
		    if (index < 0 || index > nx*ny*nz) {
			DRPerror("index out of range (%d) [2,0]", index);
		    }
		    z[i][j] = (PLFLT)rp[index];
		}
	    }
	    break;
	  case 1:
	    for (i = 0; i < nx; i++) {
		for (j = 0; j < ny; j++) {
		    index = (i*axis[1].dim + plane)*axis[0].dim+j;
		    if (index < 0 || index > nx*ny*nz) {
			DRPerror("index out of range (%d) [2,1]", index);
		    }
		    z[i][j] = (PLFLT)rp[index];
		}
	    }
	    break;
	}
	break;
    }

    tr[0] = (xmax-xmin)/(nx-1);
    tr[1] = 0.0;
    tr[2] = xmin;
    tr[3] = 0.0; 
    tr[4] = (ymax-ymin)/(ny-1);
    tr[5] = ymin;
    
#ifdef DEBUG
/*
    for (i = 0; i < nx; i++) {
	for (j = 0; j < ny; j++) {
	    printf("z[%d][%d] = %f\n", i, j, z[i][j]);
	}
    }
*/
#endif    

    xmin -= 0.5*xdelta;
    xmax += 0.5*xdelta;
    ymin -= 0.5*ydelta;
    ymax += 0.5*ydelta;

    plenv(xmin, xmax, ymin, ymax, 0, -2);
    pllab(axis[geo[0]].label, axis[geo[1]].label, NewTitle);
    plbox("bcnst", (PLFLT)0.0, 0, "bcnstv", (PLFLT)0.0, 0);

#ifdef DEBUG
/*
    printf("x: %f -- %f\n", xmin, xmax);
    printf("y: %f -- %f\n", ymin, ymax);
    printf("z: %f -- %f\n", zmin, zmax);
*/
#endif

    zmin = 0.0;
    zmax = 0.0;
    for (i = 0; i < nx*ny*nz; i++) {
	if (zmin > rp[i]) zmin = rp[i];
	if (zmax < rp[i]) zmax = rp[i];
    }
    zmin -= (zmax-zmin)*0.01;
    zmax += (zmax-zmin)*0.1;

    switch (which) {
      case SHADE:
	for (i = 0; i < nx; i++) {
	    for (j = 0; j < ny; j++) {
		xform((PLFLT)i-0.5, (PLFLT)j-0.5, &xmin, &ymin);
		xform((PLFLT)i+0.5, (PLFLT)j+0.5, &xmax, &ymax);
		xbox[0] = xmin; ybox[0] = ymin;
		xbox[1] = xmax; ybox[1] = ymin;
		xbox[2] = xmax; ybox[2] = ymax;
		xbox[3] = xmin; ybox[3] = ymax;
		xbox[4] = xmin; ybox[4] = ymin;
		plarea(5, xbox, ybox, (z[i][j]-zmin)/(zmax-zmin));
	    }
	}
	break;
      case CONTR:
	if (level == 0.0 && dl == 0.0) {
	    level = zmin;
	    dl = (zmax-zmin)/10.0;
	    if (dl <= 0.0) dl = 1.0;
	}
	nl = 0;
	swap = level;
	while (level < zmax) {
	    nl++;
	    level += dl;
	}
	level = swap;
	clevel = (PLFLT *)calloc(nl, sizeof(PLFLT));
	for (i = 0; i < nl; i++) {
	    clevel[i] = level;
	    level += dl;
	}
	plcont(z, nx, ny, 1, nx, 1, ny, clevel, nl, xform);
	free(clevel);
	break;
      case SPECT:
	xv = (PLFLT *)calloc(nz, sizeof(PLFLT));
	yv = (PLFLT *)calloc(nz, sizeof(PLFLT));
	if (xv == NULL || yv == NULL) DRPerror("memory allocation failure");
	for (i = 0; i < nx; i++) {
	    for (j = 0; j < ny; j++) {
#ifdef DEBUG
		printf("showcube spect %d %d\n", i, j);
		printf("%d %d\n", nx, ny);
		printf("%d %d\n", axis[0].dim, axis[1].dim);
		for (k = 0; k < 3; k++) 
		  printf("%f\n", rp[(k*axis[1].dim + j)*axis[0].dim + i]);
#endif
		xform((PLFLT)i-0.5, (PLFLT)j-0.5, &xmin, &ymin);
		xform((PLFLT)i+0.5, (PLFLT)j+0.5, &xmax, &ymax);
		xbox[0] = xmin; ybox[0] = ymin;
		xbox[1] = xmax; ybox[1] = ymin;
		xbox[2] = xmax; ybox[2] = ymax;
		xbox[3] = xmin; ybox[3] = ymax;
		xbox[4] = xmin; ybox[4] = ymin;
	        plline(5, xbox, ybox);
		for (k = 0; k < nz; k++) {
		    xv[k] = xmin + k * (xmax-xmin)/(nz-1);
		    yv[k] = rp[(k*axis[1].dim + j)*axis[0].dim + i];
		    yv[k] = ymin + (ymax-ymin)*(yv[k]-zmin)/(zmax-zmin);
		}
		plline(k, xv, yv);
	    }
	}
	free(yv);
	free(xv);
	break;
    }
    
    for (i = 0; i < nx; i++) {
	free(z[i]);
    }
    free(z);
    free(y); 
    free(x);
}

/*
    if (xmin > xmax) {
	for (i = 0; i < nx/2; i++) {
	    swap = x[i];
	    x[i] = x[nx-1-i];
	    x[nx-1-i] = swap;
	}
	for (i = 0; i < nx/2; i++) {
	    for (j = 0; j < ny; j++) {
		swap = z[i][j];
		z[i][j] = z[nx-1-i][j];
		z[nx-1-i][j] = swap;
	    }
	}
    }

    if (ymin > ymax) {
	for (i = 0; i < ny/2; i++) {
	    swap = y[i];
	    y[i] = y[ny-1-i];
	    y[ny-1-i] = swap;
	}
	for (i = 0; i < nx; i++) {
	    for (j = 0; j < ny/2; j++) {
		swap = z[i][j];
		z[i][j] = z[i][ny-1-j];
		z[i][ny-1-j] = swap;
	    }
	}
    }

    xmin2d = -1.0;
    xmax2d =  1.0;
    ymin2d = -1.0;
    ymax2d =  1.0;
    plenv(xmin2d, xmax2d, ymin2d, ymax2d, 0, -2);

    basex = 1.0;
    basey = 1.0;
    height = 1.0;
    alt = 45.0;
    az = 30.0;
    side = 1;
    plw3d(basex, basey, height, xmin, xmax, ymin, ymax, zmin, zmax, alt, az);
    opt = 1;
    plot3d(x, y, z, nx, ny, opt, side);
*/

