#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "plplot.h"
#include "drp.h"
#include "options.h"

#define NO  0
#define YES 1  

void plsfile(FILE *);

char PROGRAM_NAME[] = "showfit";
char description[] = "plot fit results on top of existing plot";
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(EX_SUCCESS);
    }
    Syntax(**pargv);
}

int plfit(void);

int main(int argc, char *argv[])
{
    FILE *meta;
    int error;
    static char metaname[MAXNAMLEN+1];
  
    GetOpts(argc, argv);

    if (fork() == 0) {
	strcpy(metaname, getenv("HOME"));
	strcat(metaname, METAFILE);
	meta = fopen(metaname, "a");
	if (meta == NULL) DRPerror("can't open metacode file");
	plsfile(meta);
	plstart("plmeta", 1, 1); 
    } else {
	plstart(PLDEVICE, 1, 1); 
    }
    plfontld(1);
    plfont(2);
    plwid(4);
    if ((error = plfit()) != 0) DRPwarning("error in 'plfit'");
    plend();

    exit (0);
}
