#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "drp.h"
#include "options.h"

static double red = 2.0;

char PROGRAM_NAME[] = "smooth";
char description[] = "smooth spectrum resolution by given factor";
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
{ "-factor factor",             "specify smoothing factor" }, 
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    if (!strcmp(opt, "factor")) {
	GetOption(&optarg, pargc, pargv);
	red = atof(optarg);
	return;
    }
    Syntax(**pargv);
}

#define TWOPI 6.283185307

SCAN OnScan, temp;
  
int main(int argc, char *argv[])
{
    int i, j, n, l, u;
    double freq, delta, sum, sumw, weight;
    double v, f;
  
    GetOpts(argc, argv);

    GetScan(&OnScan);

    v = Velocity(0, &OnScan);
    f = Frequency(0, &OnScan);

    v += OnScan.VelRes*(red-1.0)/2.0;
    f += OnScan.FreqRes*(red-1.0)/2.0;
  
    temp.RestFreq = OnScan.RestFreq;
    n = CenterCh(&OnScan);
    temp.NChannel = floor((OnScan.NChannel-n-0.5)/red-0.5)
      +floor((n+0.5)/red-0.5)+1;
    temp.FreqRes = OnScan.FreqRes*red;
    n = (int)red;
  
    freq = OnScan.RestFreq-temp.FreqRes*CenterCh(&temp);
    for (i = 0; i < temp.NChannel; i++) {
	l = FChannel(freq, &OnScan)-n; u = l+2*n+1;
	if (l < 0) l = 0; 
	if (u > OnScan.NChannel) u = OnScan.NChannel;
	sum = sumw = 0.0;
	for (j = l; j < u; j++) { 
	    delta = (Frequency(j,&OnScan)-freq)/OnScan.FreqRes/red;
	    weight = exp(-TWOPI*delta*delta);
	    sum += OnScan.Channels[j]*weight;
	    sumw += weight;
	}
	temp.Channels[i] = sum/sumw;
	freq += temp.FreqRes; 
    }

    for (i=0; i<temp.NChannel; i++) OnScan.Channels[i] = temp.Channels[i];

    OnScan.FreqRes = temp.FreqRes;
    OnScan.NChannel = temp.NChannel;
    OnScan.VelRes  *= red;
    OnScan.Bandwidth = OnScan.FreqRes*OnScan.NChannel;
    OnScan.VSource = v + CenterCh(&OnScan)*OnScan.VelRes;
    OnScan.RestFreq = f + CenterCh(&OnScan)*OnScan.FreqRes;

    PutScan (&OnScan);

    exit(0);
}
