#include <stdio.h>
#include <stdlib.h>
#include <math.h>

void DRPerror(char *, ...);

#ifndef TINY
#define TINY 1.0e-20
#endif

int ludcmp(double **a, int n, int indx[], double *d) {
    double aamax, aa, *vv, sum, dum;
    int i, j, k, imax = 0;

    vv = (double *)calloc(n, sizeof(double));
    if (vv == NULL) DRPerror("memory allocation failure");

    *d = 1.0;
    for (i=0; i<n; i++) {
        aamax = 0.0;
        for (j=0; j<n; j++) {
	    if ((aa=fabs((double)a[i][j])) > aamax) aamax = aa;
        }
        if (aamax == 0.0) {
            free(vv);
            return (1);
	}
        vv[i] = 1.0/aamax;
    }
    for (j=0; j<n; j++) {
        for (i=0; i<j; i++) {
            sum = a[i][j];
	    for (k=0; k<i; k++) sum -= a[i][k]*a[k][j];
	    a[i][j] = sum;
        }
        aamax = 0.0;
        for (i=j; i<n; i++) {
	    sum = a[i][j];
	    for (k=0; k<j; k++) sum -= a[i][k]*a[k][j];
	    a[i][j] = sum;
	    dum = vv[i]*fabs(sum);
	    if (dum >= aamax) {
	        imax = i;
	        aamax = dum;
	    }
        }
        if (j != imax) {
	    for (k=0; k<n; k++) {
	        dum = a[imax][k];
	        a[imax][k] = a[j][k];
	        a[j][k] = dum;
	    }
	    *d *= -1.0;
	    vv[imax] = vv[j];
        }
        indx[j] = imax;
        if (j < n-1) {
	    if (a[j][j] == 0.0) a[j][j] = TINY;
	    dum = 1.0/a[j][j];
	    for (i=j+1; i<n; i++) a[i][j] *= dum;
        }
    }
    if (a[n-1][n-1] == 0.0) a[n-1][n-1] = TINY;
    free(vv);

    return (0);
}

void lubksb(double *a[], int n, int indx[], double b[]) {
    int i, j, ii, ll;
    double sum;

    ii = -1;
    for (i=0; i<n; i++) {
        ll = indx[i];
        sum = b[ll];
        b[ll] = b[i];
        if (ii > -1) {
	    for (j=ii; j<i; j++) sum -= a[i][j]*b[j];
        } else if (sum != 0.0) ii = i;
        b[i] = sum;
    }
    for (i=n-1; i>=0; i--) {
        sum = b[i];
        for (j=i+1; j<n; j++) sum -= a[i][j]*b[j];
        b[i] = sum/a[i][i];
    }
}

double matinv(double **a, int n) {
    double **y, Det;
    int i, j, *indx;

    indx = (int *)calloc(n,sizeof(int));
    if (indx == (int *)NULL) DRPerror("memory allocation failure");

    y = (double **)calloc(n, sizeof(double *));
    if (y == NULL) DRPerror("memory allocation failure");
    for (i = 0; i < n; i++) {
        y[i] = (double *)calloc(n, sizeof(double));
        if (y[i] == NULL) DRPerror("memory allocation failure");
    }

    if (ludcmp(a, n, indx, &Det) == 1) return (0.0);
    for (i = 0; i < n; i++) {
	Det *= a[i][i];
	for (j = 0; j < n; j++) y[i][j] = 0.0;
	y[i][i] = 1.0;
	lubksb(a, n, indx, y[i]);
    }
    for (i = 0; i < n; i++) {
	for (j = 0; j < n; j++) a[i][j] = y[i][j];
    }

    return (Det);
}

int solve(double **a, double *v, int n) {
    int *indx;
    double Det;

    indx = (int *)calloc((unsigned)n,sizeof(int));
    if (indx == (int *)NULL) DRPerror("memory allocation failure");

    if (ludcmp(a, n, indx, &Det) == 1) return (0);
    else {
	lubksb(a, n, indx, v);
	return (1);
    }
}
