/*	tek.c

	PLPLOT tektronix device driver.
*/
#ifdef TEK

#include <stdio.h>
#include "plplot.h"
#include "dispatch.h"

/* Function prototypes */

void tekinit		PLARGS((PLStream *));

/* top level declarations */

#define TEKX   1023
#define TEKY    779

/* Graphics control characters. */

#define FF   12
#define CAN  24
#define ESC  27
#define GS   29
#define US   31

/* (dev) will get passed in eventually, so this looks weird right now */

static PLDev device;
static PLDev *dev = &device;

/*----------------------------------------------------------------------*\
* tektinit()
*
* Initialize device (terminal).
\*----------------------------------------------------------------------*/

void 
tektinit(pls)
PLStream *pls;
{
    pls->termin = 1;			/* an interactive device */

    pls->OutFile = stdout;
    pls->orient = 0;
    tekinit(pls);
/*    fprintf(pls->OutFile, "%c%c", ESC, FF);	*//* mgg 07/23/91 via rmr */
}

/*----------------------------------------------------------------------*\
* tekfinit()
*
* Initialize device (file).
\*----------------------------------------------------------------------*/

void 
tekfinit(pls)
PLStream *pls;
{
    pls->termin = 0;			/* not an interactive terminal */

/* Initialize family file info */

    plFamInit(pls);

/* Prompt for a file name if not already set */

    plOpenFile(pls);

/* Set up device parameters */

    tekinit(pls);
}

/*----------------------------------------------------------------------*\
* tekinit()
*
* Generic device initialization.
\*----------------------------------------------------------------------*/

void
tekinit(pls)
PLStream *pls;
{
    pls->color = 1;
    pls->width = 1;
    pls->bytecnt = 0;
    pls->page = 0;

    dev->xold = UNDEFINED;
    dev->yold = UNDEFINED;
    dev->xmin = 0;
    dev->xmax = TEKX;
    dev->ymin = 0;
    dev->ymax = TEKY;

    if (!pls->orient) {				/* landscape mode */

	setpxl((PLFLT) (4.771 * 16), (PLFLT) (4.653 * 16));

	setphy(0, TEKX * 16, 0, TEKY * 16);
    }

    else {					/* portrait mode */

	setpxl((PLFLT) (4.653 * 16), (PLFLT) (4.771 * 16));

	setphy(0, TEKY * 16, 0, TEKX * 16);
    }
    fprintf(pls->OutFile, "%c", GS);
}

/*----------------------------------------------------------------------*\
* tekline()
*
* Draw a line in the current color from (x1,y1) to (x2,y2).
\*----------------------------------------------------------------------*/

void 
tekline(pls, x1a, y1a, x2a, y2a)
PLStream *pls;
PLINT x1a, y1a, x2a, y2a;
{
    int x1, y1, x2, y2, hy, ly, hx, lx;

    x1a >>= 4;
    y1a >>= 4;
    x2a >>= 4;
    y2a >>= 4;

    x1 = x1a; y1 = y1a; x2 = x2a; y2 = y2a;

    plRotPhy(pls, dev, &x1, &y1, &x2, &y2);
    if (pls->pscale)
	plSclPhy(pls, dev, &x1, &y1, &x2, &y2);

/* If continuation of previous line just send new point */

    if (x1 == dev->xold && y1 == dev->yold) {
	hy = y2 / 32 + 32;
	ly = y2 - (y2 / 32) * 32 + 96;
	hx = x2 / 32 + 32;
	lx = x2 - (x2 / 32) * 32 + 64;
	fprintf(pls->OutFile, "%c%c%c%c", hy, ly, hx, lx);
	pls->bytecnt += 4;
    }
    else {
	fprintf(pls->OutFile, "%c", GS);
	hy = y1 / 32 + 32;
	ly = y1 - (y1 / 32) * 32 + 96;
	hx = x1 / 32 + 32;
	lx = x1 - (x1 / 32) * 32 + 64;
	fprintf(pls->OutFile, "%c%c%c%c", hy, ly, hx, lx);
	hy = y2 / 32 + 32;
	ly = y2 - (y2 / 32) * 32 + 96;
	hx = x2 / 32 + 32;
	lx = x2 - (x2 / 32) * 32 + 64;
	fprintf(pls->OutFile, "%c%c%c%c", hy, ly, hx, lx);
	pls->bytecnt += 9;
    }
    dev->xold = x2;
    dev->yold = y2;
}

/*----------------------------------------------------------------------*\
* tekclear()
*
* Clear page.  User must hit a <CR> to continue (terminal output).
\*----------------------------------------------------------------------*/

void 
tekclear(pls)
PLStream *pls;
{
    if (pls->termin) {
/*	putchar('\007');
	fflush(stdout);
	while (getchar() != '\n');  */
    }
    fprintf(pls->OutFile, "%c%c", ESC, FF);
}

/*----------------------------------------------------------------------*\
* tekpage()
*
* Set up for the next page.  
* Advance to next family file if necessary (file output).
\*----------------------------------------------------------------------*/

void 
tekpage(pls)
PLStream *pls;
{
    dev->xold = UNDEFINED;
    dev->yold = UNDEFINED;

    if (!pls->termin)
	plGetFam(pls);

    pls->page++;
}

/*----------------------------------------------------------------------*\
* tekadv()
*
* Advance to the next page.
\*----------------------------------------------------------------------*/

void 
tekadv(pls)
PLStream *pls;
{
    tekclear(pls);
    tekpage(pls);
}

/*----------------------------------------------------------------------*\
* tektidy()
*
* Close graphics file or otherwise clean up.
\*----------------------------------------------------------------------*/

void 
tektidy(pls)
PLStream *pls;
{
    if (!pls->termin) {
	fclose(pls->OutFile);
    }
    else {
	tekline(pls, 0, TEKY, 0, TEKY);
/*	tekclear(pls);  */
	putchar('\007');
	fflush(stdout);
	while (getchar() != '\n');
	fprintf(pls->OutFile, "%c%c", US, CAN);
	fflush(pls->OutFile);
    }
    pls->fileset = 0;
    pls->page = 0;
    pls->OutFile = NULL;
}

/*----------------------------------------------------------------------*\
* tekcolor()
*
* Set pen color.
\*----------------------------------------------------------------------*/

void 
tekcolor(pls)
PLStream *pls;
{
}

/*----------------------------------------------------------------------*\
* tektext()
*
* Switch to text mode.
\*----------------------------------------------------------------------*/

void 
tektext(pls)
PLStream *pls;
{
    fprintf(pls->OutFile, "%c", US);
}

/*----------------------------------------------------------------------*\
* tekgraph()
*
* Switch to graphics mode.
\*----------------------------------------------------------------------*/

void 
tekgraph(pls)
PLStream *pls;
{
}

/*----------------------------------------------------------------------*\
* tekwidth()
*
* Set pen width.
\*----------------------------------------------------------------------*/

void 
tekwidth(pls)
PLStream *pls;
{
}

/*----------------------------------------------------------------------*\
* tekesc()
*
* Escape function.
\*----------------------------------------------------------------------*/

void 
tekesc(pls, op, ptr)
PLStream *pls;
PLINT op;
char *ptr;
{
}
#endif	/* TEK */
