#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include "plplot.h"
#include "drp.h"
#include "options.h"

#define NO  0
#define YES 1  

void plsfile(FILE *);

/* defaults */
double xMin = 0.0, xMax = 0.0;
double yMin = 0.0, yMax = 0.0;
int xUnit = VELOCITY;
int Units = YES;
int xLabels = YES;
int yLabels = YES;
int frame = YES;
int draft = YES;
int overwrite = NO;
int zeroline = NO;
int grid = NO;
int title = NO;
char NewTitle[80];

char PROGRAM_NAME[] = "twplot";
char description[] = "produce scatter plot 'temp' versus 'work'";
char required[] = "";
struct _options options[] = {
{ "-help",		"Print out this message" },
{ "-vel v1 v2",		"select velocity range" },
{ "-freq f1 f2",	"select frequency range" },
{ "-chan c1 c2",	"select channel range" },
{ "-over",		"write over existing plot" },
{ "-zero",		"draw y = 0.0 line" },
{ "-title text",        "specify new title for plot" },
{ "-noframe",           "don't draw coordinate frame" },
{ "-nodraft",		"use extended font for high quality labels" },
{ "-grid",              "draw grid at major tick intervals" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(EX_SUCCESS);
    }
    if (!strcmp(opt, "vel")) {
	GetOption(&optarg, pargc, pargv);
	xMin = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	xMax = atof(optarg);
	xUnit = VELOCITY;
	return;
    }
    if (!strcmp(opt, "freq")) {
	GetOption(&optarg, pargc, pargv);
	xMin = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	xMax = atof(optarg);
	xUnit = FREQUENCY;
	return;
    }
    if (!strcmp(opt, "chan")) {
	GetOption(&optarg, pargc, pargv);
	xMin = (double)atoi(optarg);
	GetOption(&optarg, pargc, pargv);
	xMax = (double)atoi(optarg);
	xUnit = CHANNELS;
	return;
    }
    if (!strcmp(opt, "temp")) {
	GetOption(&optarg, pargc, pargv);
	yMin = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	yMax = atof(optarg);
	return;
    }
    if (!strcmp(opt, "over")) {
	overwrite = YES;
	return;
    }
    if (!strcmp(opt, "zero")) {
	zeroline = YES;
	return;
    }
    if (!strcmp(opt, "title")) {
	title = YES;
	GetOption(&optarg, pargc, pargv);
	strcpy(NewTitle, optarg);
	return;
    }
    if (!strcmp(opt, "noframe")) {
	frame = NO;
	return;
    }
    if (!strcmp(opt, "nodraft")) {
	draft = NO;
	return;
    }
    if (!strcmp(opt, "grid")) {
	grid = YES;
	return;
    }
    Syntax(**pargv);
}

void scatter(int , float , float );

int main (int argc, char *argv[])
{
    FILE *meta;
    double swap;
    static char metaname[MAXNAMLEN+1];
     
    GetOpts(argc, argv);

    if (xMin > xMax) {	swap = xMin;	xMin = xMax;	xMax = swap;    }

    if (fork() == 0) {
	strcpy(metaname, getenv("HOME"));
	strcat(metaname, METAFILE);
	if (!overwrite) meta = fopen(metaname, "w");
	else            meta = fopen(metaname, "a");
	if (meta == NULL) DRPerror("can't open metacode file '%s'", metaname);
	plsfile(meta);
	plstart("plmeta", 1, 1); 
/*	plfontld(1);
	plfont(2);
	plwid(4); */
	scatter(xUnit, (float)xMin, (float)xMax);
	plend();
    } else {
	plstart(PLDEVICE, 1, 1); 
	if (!overwrite) plclr();
	scatter(xUnit, (float)xMin, (float)xMax);
	plend();
    }

    exit(EX_SUCCESS);
}
