#include "garmindialog.h"
#include "ui_garmindialog.h"

#include <QString>
#include <QStringList>
#include <QSettings>
#include <QDir>
#include <QDebug>

GarminDialog::GarminDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::GarminDialog)
{
    QSettings settings("qtrainer", "qtrainer");
    QString td = settings.value("garmin/directory", QDir::homePath()).toString();

    QDir::setCurrent(td);
    qDebug() << "storing tracks in:" << td;
    QString program = "/usr/bin/garmin_save_runs";
    QStringList arguments;

    ui->setupUi(this);
    ui->progressBar->setTextVisible(false);
    ui->progressBar->setValue(0);
    ui->progressBar->setMinimum(0);
    ui->progressBar->setMaximum(0);

    proc = new QProcess();
    connect(proc, SIGNAL(readyReadStandardOutput()),
            this, SLOT(readPipe()));
    connect(proc, SIGNAL(finished(int,QProcess::ExitStatus)),
            this, SLOT(donePipe(int,QProcess::ExitStatus)));
    ui->plainTextEdit->appendPlainText(QString("> cd ").append(td));
    ui->plainTextEdit->appendPlainText(QString("> ").append(program));
    proc->start(program, arguments);
    ui->okButton->setEnabled(false);
}

GarminDialog::~GarminDialog()
{
    delete ui;
}

void GarminDialog::readPipe()
{
    qDebug() << "read pipe";
    ui->plainTextEdit->appendPlainText(proc->readAllStandardOutput());
    ui->progressBar->setRange(0,100);
    ui->progressBar->setValue(50);
}

void GarminDialog::donePipe(int exitCode, QProcess::ExitStatus exitStatus)
{
    if (exitStatus == QProcess::NormalExit) {
        qDebug() << "normal exit";
        ui->progressBar->setValue(100);
        ui->okButton->setText("Done");
        ui->okButton->setEnabled(true);
        // close();
    } else {
        qDebug() << "crashed";
        qDebug() << exitCode;
    }
}
