#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QtSql>
#include <QProcess>
#include <QXmlStreamReader>
#include <QLabel>

#include <qwt_plot_curve.h>
#include <qwt_array.h>
#include <qwt_text.h>
#include <qwt_plot_grid.h>
#include <qwt_plot_picker.h>
#include <qwt_scale_draw.h>
#include <qwt_scale_widget.h>
#include <qwt_plot_marker.h>

#include <qmapcontrol/mapcontrol.h>
#include <qmapcontrol/osmmapadapter.h>
#include <qmapcontrol/yahoomapadapter.h>
#include <qmapcontrol/googlemapadapter.h>
#include <qmapcontrol/maplayer.h>
#include <qmapcontrol/point.h>
#include <qmapcontrol/circlepoint.h>
#include <qmapcontrol/imagepoint.h>
#include <qmapcontrol/linestring.h>

class Track;

namespace Ui {
    class MainWindow;
}

using namespace qmapcontrol;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    QString lastdir;
    Ui::MainWindow *ui;
    QSqlDatabase db;
    QSqlQueryModel *model;
    QXmlStreamReader xml;
    Track *currentTrack;
    MapControl* mc;
    MapAdapter* mapadapter;
    Layer* l;
    LineString *lstr;
    CirclePoint *cpt;
    ImagePoint *ipt;
    void addZoomButtons();
    int noOfTracks;
    QwtPlotCurve *speed;
    QwtPlotCurve *pulse;
    QwtPlotCurve *profile;
    QwtPlotGrid *grid1;
    QwtPlotGrid *grid2;
    QwtPlotGrid *grid3;
    QwtPlotPicker *picker1;
    QwtPlotPicker *picker2;
    QwtPlotPicker *picker3;
    QwtPlotMarker *pace6;
    QwtPlotMarker *pace5;
    QwtPlotMarker *pace4;
    QwtPlotMarker *meanHR;
    QwtPlotMarker *maxHR;
    QProcess *proc;
    QLabel *dateLabel;
    QLabel *trackLabel;
    QLabel *statistics;
    int noTrackPoints;
    int nextId;
    bool checkDatabase();

private slots:
    void createStatusBar();
    void on_actionAbout_triggered();
    void on_actionOpen_triggered();
    void on_actionImport_triggered();
    void on_actionStatistics_triggered();
    void on_actionQuit_triggered();
    void displayMap();
    void trackSelected(int row);
    void editTrack(int row, int column);
    void retrieveTrack(int id);
    void retrieveTable();
    void addToDb(int id, const QString &name, const QString &start);
    void addToTable(int id, const QString &name, 
                    const QString &start, double total);
    void showSpeed();
    void showPulse();
    void showProfile();
    void updateStatus();
    void markCurrent(QwtDoublePoint pos);
    void readPipe();
    void donePipe(int exitCode, QProcess::ExitStatus exitStatus);
    void parseXML();
};

#endif // MAINWINDOW_H
