#include <math.h>
#include <QDebug>

#include "savgol.h"

SavGolFilter::SavGolFilter(int beg, int end, int ld, int m)
{
    int d, icode, imj, ipj, i, j, k, kk, mm, np;
    qreal fac, sum;
    qreal *b;

    nl = beg;
    nr = end;
    np = nl+nr+1;
    c.resize(np);
    if (nl < 0 || nr < 0 || ld > m || nl+nr < m) {
        qDebug() << "Bad args in savgol.";
        return;
    }

    a = new qreal *[m+1];
    for (i = 0; i < m+1; i++) {
        a[i] = new qreal[m+1];
    }
    b = new qreal[m+1];
    indx = new int[m+1];

    for (i = 0; i < m+1; i++) {
        for (j = 0; j < m+1; j++) a[i][j] = 0.0;
        b[i] = 0.0;
        indx[i] = 0;
    }

    for (ipj = 0; ipj <= 2*m; ipj++) {
        sum = 0.0;
        if (ipj == 0) sum = 1.0;
        for (k = 0; k < nr; k++) sum += pow((qreal)( k+1), (qreal)ipj);
        for (k = 0; k < nl; k++) sum += pow((qreal)(-k-1), (qreal)ipj);
        mm = min(ipj, 2*m-ipj);
        mm = min(ipj, 2*m-ipj);
        for (imj = -mm; imj <= mm; imj += 2) {
            a[(ipj-imj)/2][(ipj+imj)/2] = sum;
	}
    }

    icode = ludcmp(m+1, &d);
    if (icode != 0) qDebug() << "ludcmp error!";

    for (j = 0; j < m+1; j++) b[j] = 0.0;
    b[ld] = 1.0;

    lubksb(m+1, b);
    for (kk = 0; kk < np; kk++) c[kk] = 0.0;
    for (k = -nl; k <= nr; k++) {
        sum = b[0];
        fac = 1.0;
        for (mm = 1; mm <= m; mm++) {
            fac *= (qreal)k;
            sum += b[mm]*fac;
        } 
        kk = (np-k) % np;
        c[kk] = sum;
    }
    for (i = 0; i < m+1; i++) delete a[i];
    delete []a;
    delete indx;
    delete b;
}

SavGolFilter::~SavGolFilter()
{
}

qreal *SavGolFilter::filter(const QVector<qreal> &raw)
{
    int i, j;
    int n = raw.size();
    int *off = new int[nl+nr+1];
    off[0] = 0;
    j = 2;
    for (i = 1; i < nl+1; i++) {
        off[i] = i-j;
        j += 2;
    }
    j = 1;
    for (i = nl+1; i < nl+nr+1; i++) {
        off[i] = i-j;
        j += 2;
    }

    out.resize(n);
    for (i = 0; i < nl; i++) out[i] = raw[i];
    for (i = nl; i < n-nr; i++) {
        out[i] = 0.0;
        for (j = 0; j < nl+nr+1; j++)
            if (i+off[j] >= 0) out[i] += c[j]*raw[i+off[j]];
    }
    for (i = n-nr; i < n; i++) out[i] = raw[i];
    delete off;
    return out.data();
}

int SavGolFilter::ludcmp(int n, int *d)
{
    const qreal TINY = 1.0e-12;

    qreal amax, dum, sum;
    qreal *vv;
    int   i, imax, j, k;

    imax = 0;
    vv = new qreal[n];
    *d = 1;
    for (i = 0; i < n; i++) {
        amax = 0.0;
        for (j = 0; j < n; j++)
            if (fabs(a[i][j]) > amax) amax = fabs(a[i][j]);
        if (amax < TINY) {
            return 1;
        }
        vv[i] = 1.0/amax;
    }

    for (j = 0; j < n; j++) {
        for (i = 0; i < j; i++) {
            sum = a[i][j];
            for (k = 0; k < i; k++) sum -= a[i][k]*a[k][j];
            a[i][j] = sum;
        }
        amax = 0.0;
        for (i = j; i < n; i++) {
            sum = a[i][j];
            for (k = 0; k < j; k++) sum -= a[i][k]*a[k][j];
            a[i][j] = sum;
            dum = vv[i]*fabs(sum);
            if (dum >= amax) {
                imax = i;
                amax = dum;
            }
        }  
        if (j != imax) {
            for (k = 0; k < n; k++) {
                dum = a[imax][k];
                a[imax][k] = a[j][k];
                a[j][k] = dum;
            }
            *d = -(*d);
            vv[imax] = vv[j];
        }

        indx[j] = imax;
        if (j < n-1) {
	    if (a[j][j] == 0.0) a[j][j] = TINY;
	    dum = 1.0/a[j][j];
	    for (i=j+1; i<n; i++) a[i][j] *= dum;
        }
    }
    if (a[n-1][n-1] == 0.0) a[n-1][n-1] = TINY;
    delete vv;
    return 0;
}

void SavGolFilter::lubksb(int n, qreal *b)
{
    qreal sum;
    int i, ii, j, ll;

    ii = -1;
    for (i = 0; i < n; i++) {
        ll = indx[i];
        sum = b[ll];
        b[ll] = b[i];
        if (ii > -1) {
            for (j = ii; j < i; j++) sum -= a[i][j]*b[j];
        } else if (sum != 0.0) ii = i;
        b[i] = sum;
    }

    for (i = n-1; i >= 0; i--) {
        sum = b[i];
        for (j = i+1; j < n; j++) sum -= a[i][j]*b[j];
        b[i] = sum/a[i][i];
    }
}
