#include <QtCore>
#include <QVector>

class SavGolFilter
{
public:
    SavGolFilter(int beg, int end, int ld, int m);
    ~SavGolFilter();
    qreal coefficient(int i) { return c[i]; };
    qreal *filter(const QVector<qreal> &raw);

private:
    int ludcmp(int n, int *d);
    void lubksb(int n, double *b);
    qreal **a;
    int nl, nr;
    int *indx;
    QVector<qreal> c;
    QVector<qreal> out;
    int min(int ia, int ib) { return ia <= ib ? ia : ib; };
};
