#include <QDate>
#include <QDateTime>
#include <QDebug>

#include "statistics.h"
#include "ui_statistics.h"

StatisticsDialog::StatisticsDialog(QWidget *parent) :
    QDialog(parent), ui(new Ui::Statistics)
{
    ui->setupUi(this);
    ui->treeWidget->setColumnCount(2);
    // addRoot(QString().setNum(2011), 123.4);
}

StatisticsDialog::~StatisticsDialog()
{
    delete ui;
}

void StatisticsDialog::displayStats(QTableWidget *tbl)
{
    int nr;
    int year = 0, month = 0, week = 0;
    QTreeWidgetItem *root, *child, *grandchild;
    QDate date;
    double d, totalYear = 0.0, totalMonth = 0.0, totalWeek = 0.0;
    QString start;

    nr = tbl->rowCount();
    root = 0;
    child = 0;
    grandchild = 0;
    for (int id=0; id < nr; id++) {
        start = tbl->item(id, 0)->text();
        date = QDateTime::fromString(start, "yyyy-MM-dd hh:mm:ss").date();
        d = tbl->item(id, 2)->text().toDouble();
        if (date.year() != year) {
            if (root) updateItem(root, totalYear);
            year = date.year();
            root = addRoot(QString().setNum(year));
            totalYear = 0.0;
        }
        if (date.month() != month) {
            if (child) updateItem(child, totalMonth);
            // if (grandchild) {
            //     updateItem(grandchild, totalWeek);
            //     totalWeek = 0.0;
            //     week = 0;
            // }
            month = date.month();
            child = addChild(root, QDate::longMonthName(month));
            totalMonth = 0.0;
        }
        if (date.weekNumber() != week) {
            if (grandchild) updateItem(grandchild, totalWeek);
            week = date.weekNumber();
            grandchild = addChild(child, QString("week %1").arg(week));
            totalWeek = 0.0;
        }
        totalYear += d;
        totalMonth += d;
        totalWeek += d;
    }
    if (root) updateItem(root, totalYear);
    if (child) updateItem(child, totalMonth);
    if (grandchild) updateItem(grandchild, totalWeek);
}

QTreeWidgetItem *StatisticsDialog::addRoot(QString period)
{
    QTreeWidgetItem *root = new QTreeWidgetItem(ui->treeWidget);
    root->setText(0, period);
    root->setText(1, "NA");
    ui->treeWidget->addTopLevelItem(root);
    return root;
}

QTreeWidgetItem *StatisticsDialog::addChild(QTreeWidgetItem *parent, 
                                QString period)
{
    QTreeWidgetItem *child = new QTreeWidgetItem();
    child->setText(0, period);
    child->setText(1, "NA");
    parent->addChild(child);
    return child;
}

void StatisticsDialog::updateItem(QTreeWidgetItem *item, double total)
{
    item->setText(1, QString().setNum(total, 'f', 3));
    item->setTextAlignment(1, Qt::AlignRight);
}
