#ifndef TRACK_H
#define TRACK_H

#include <QString>
#include <QDateTime>
#include <QPointF>
#include <QVector>

class TrackPoint
{
public:
    TrackPoint();
    TrackPoint(const QDateTime time, const double lon, 
               const double lat, const double alt, 
               const double d, const double hr);
    QPointF position() const;
    QString toString() const;
    void dump() const;

    QDateTime tstamp;
    double longitude;
    double latitude;
    double altitude;
    double distance;
    double hrate;
};

class Track
{
public:
    Track(QPointF home, int id = -1);
    QPointF centre();
    QString name() const;
    void setName(QString name);
    int id();
    void setId(int id);
    QDateTime date() const;
    void dump() const;
    void addPoint(const QDateTime time, const double lon, 
                  const double lat, const double alt, 
                  const double d, const double hr);
    void smoothVel0();
    void smoothVel1();
    void smoothVel2();
    void reset();
    int length() const;
    double meanPace() const;
    double maxPace() const;
    double meanPulse() const;
    double maxPulse() const;
    double totalLength() const;
    QTime  totalTime() const;
    QPointF pointAt(int) const;
    static double mean(QVector<qreal>);
    static double max(QVector<qreal>);
    QVector<qreal> t; // time since start
    QVector<qreal> s; // distance
    QVector<qreal> h; // altitude
    QVector<qreal> v; // speed
    QVector<qreal> p; // pulse
    QVector<QPointF> pos; // longitude,latitude positions

private: 
    qreal median(qreal a, qreal b, qreal c);
    bool filled;
    int _id;
    QString which;
    QDateTime when;
    QPointF where;
};

#endif // TRACK_H
